#version 330
#extension GL_EXT_gpu_shader4 : enable
//Bonzomatic test run #9Mod01.fsh  by  Exca
//https://www.shadertoy.com/view/WtSXRh
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec3 rep(vec3 p, vec3 q)
{
  return mod(p,q)-0.5*q;
}

float box(vec3 p, vec3 q)
{
  vec3 d = abs(p)-q;
  return length(max(d,0.0));
}

float sphere(vec3 p, float r)
{
  return length(p)-r;
}

vec2 cmin(vec2 a, vec2 b)
{
  return a.x < b.x ?a:b;
}

vec2 dist(vec3 p)
{
  vec2 s =vec2(sphere(p+vec3(0.,0.,-3.),0.3),0.);
  
  vec3 id = vec3(p.x/1.,(p.y/2.),(p.z/2.));
  p = rep(p+vec3(0.5+sin(id.z+id.y), sin(id.y)*4.,cos(id.z)*2.),vec3(6.,2.,2.));
  vec2 b = vec2(box(p+vec3(0.0), vec3(0.8)),id.x+id.y);
  
  vec2 sum =cmin(s,b);
  return b;
}
vec3 light(vec3 rd,vec3 p)
{
  vec2 eps=vec2(0.,0.1);
  vec2 d1 = dist(p+eps.yxx);
  vec2 d2 = dist(p-eps.yxx);
  vec2 d3 = dist(p+eps.xyx);
  vec2 d4 = dist(p-eps.xyx);
  vec2 d5 = dist(p+eps.xxy);
  vec2 d6 = dist(p-eps.xxy);
  
  vec3 n = normalize( vec3(d1.x-d2.x, d3.x-d4.x, d5.x-d6.x));
  
  float m =max(0.,dot(-rd,n));
  vec3 di = vec3(m);
  di = vec3(1.);
  return di;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;

  uv*=2.;
  uv -= 1.;
  //uv = vec2(iResolution.y / iResolution.x, 1);
  
  vec3 target = vec3(sin(iTime), cos(iTime)*0.0+10.5+iTime*5., cos(iTime*.3));
  vec3 cam = vec3(0.,iTime*5.,-1.*sin(iTime*0.4));
  float fov =0.2;
  
  vec3 forward = normalize(target - cam);
  vec3 up = normalize( cross(forward, vec3(0.,1.,0.)));
  vec3 right = normalize( cross(forward, up));
  vec3 raydir = normalize( uv.x*right+uv.y*up+ fov*forward);
  
  
  vec3 col = vec3(0.);
  float t=0.0;
  for(int i=0;i<10000;i++)
  {
    vec3 p = raydir*t+cam;
    vec2 d=dist(p);
    t+=d.x;
    if(d.x <0.00001)
    {
      col=vec3(1.);
      float f = max(0.,(10.-t)/10.);
      col=light(raydir, p)*abs(vec3(sin(d.y*2.+1.),sin(d.y+3.),sin(d.y*.3)))*f;
      break;
    }
    if(t>100.)
    {
      break;
    }
  }  
  
  gl_FragColor = vec4(col, 1.);
}